/*
 * Simple test of the ni_660x driver
 *
 * This example configures the DIO0 - DIO7 for output and sequentially
 * sets each on high.
 */

#include <stdio.h>
#include <comedilib.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <sys/time.h>
#include <unistd.h>

#define DATA_1B 0x1
#define DATA_2B 0x2
#define DATA_4B 0x4

#define MAX_SAMPLES 128

int
main(int argc, char *argv[])
{
  char *filename="/dev/comedi0";
  comedi_t *device;
  int ret, i;
  comedi_insn insn;
  lsampl_t data[MAX_SAMPLES];

  device = comedi_open(filename);
  if (!device){
    comedi_perror(filename);
    exit(0);
  }

  // setup read
  data[0] = 0x00e;
  data[1] = 0x0;
  insn.insn = INSN_READ;
  insn.n = 2;
  insn.data = data;
  insn.subdev = 0;
  insn.chanspec = DATA_2B;

  ret = comedi_do_insn(device, &insn);
  if (ret < 0){
    comedi_perror(filename);
    exit(0);
  }

  printf("0x%x: 0x%x\n", data[0], data[1]);

  comedi_close(device);

  return 0;
}

