/*
 * Simple test of the ni_660x driver
 *
 * This example configures the DIO0 - DIO7 for output and sequentially
 * sets each on high.
 */

#include <stdio.h>
#include <comedilib.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <sys/time.h>
#include <unistd.h>

#define DATA_1B 0x1
#define DATA_2B 0x2
#define DATA_4B 0x4

#define MAX_SAMPLES 128

int
main(int argc, char *argv[])
{
  char *filename="/dev/comedi0";
  comedi_t *device;
  int ret, i;
  comedi_insn insn;
  lsampl_t data[MAX_SAMPLES];

  device = comedi_open(filename);
  if (!device){
    comedi_perror(filename);
    exit(0);
  }

  // enable the digital I/O outputs
  data[0] = 0x016;
  data[1] = 0xff;
  insn.insn = INSN_WRITE;
  insn.n = 2;
  insn.data = data;
  insn.subdev = 0;
  insn.chanspec = DATA_2B;

  ret = comedi_do_insn(device, &insn);
  if (ret < 0){
    comedi_perror(filename);
    exit(0);
  }

  // initialize output to 0
  data[0] = 0x014;
  data[1] = 0x0;
  insn.insn = INSN_WRITE;
  insn.n = 2;
  insn.data = data;
  insn.subdev = 0;
  insn.chanspec = DATA_2B;

  ret = comedi_do_insn(device, &insn);
  if (ret < 0){
    comedi_perror(filename);
    exit(0);
  }

  // sequentially set each output line high
  data[0] = 0x014;
  for (i=0; i<8; i++) {
    insn.insn = INSN_WRITE;
    insn.n = 2;
    data[1] = (0x1<<i);
    insn.data = data;
    insn.subdev = 0;
    insn.chanspec = DATA_2B;

    ret = comedi_do_insn(device, &insn);
    if (ret < 0){
      comedi_perror(filename);
      exit(0);
    }

    printf("%d", i);
    getchar();
  }

  // reset output to 0
  insn.insn = INSN_WRITE;
  insn.n = 2;
  data[1] = 0;
  insn.data = data;
  insn.subdev = 0;
  insn.chanspec = DATA_2B;

  ret = comedi_do_insn(device, &insn);
  if (ret < 0){
    comedi_perror(filename);
    exit(0);
  }

  comedi_close(device);

  return 0;
}

