/*
 * Simple test of the ni_660x driver
 *
 * This example configures channel 1 as a quaderature counter to sense
 * relative position
 */

#include <stdio.h>
#include <comedilib.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <sys/time.h>
#include <unistd.h>

#define DATA_1B 0x1
#define DATA_2B 0x2
#define DATA_4B 0x4

#define MAX_SAMPLES 128

int
main(int argc, char *argv[])
{
  char *filename="/dev/comedi0";
  comedi_t *device;
  int ret, i, k;
  comedi_insn insn;
  lsampl_t data[MAX_SAMPLES];

  device = comedi_open(filename);
  if (!device){
    comedi_perror(filename);
    exit(0);
  }

  k = 0;
  // reset g0 counter
  data[k++] = 0x090;
  data[k++] = 0x000c;

  insn.insn = INSN_WRITE;
  insn.n = k;
  insn.data = data;
  insn.subdev = 0;
  insn.chanspec = DATA_2B;

  ret = comedi_do_insn(device, &insn);
  if (ret < 0){
    comedi_perror(filename);
    exit(0);
  }

  k = 0;
  // setup g0 counting mode register
  data[k++] = 0x0b0;
  data[k++] = 0x0000;
  // setup g0 input select register
  data[k++] = 0x048;
  //data[k++] = 0x0000;
  data[k++] = 0x0084;
  // setup g0 second gate register
  data[k++] = 0x0b4;
  data[k++] = 0x0080;
  // setup g0 mode register -- gate not used
  data[k++] = 0x034;
  data[k++] = 0x0018;

  insn.insn = INSN_WRITE;
  insn.n = k;
  insn.data = data;
  insn.subdev = 0;
  insn.chanspec = DATA_2B;

  ret = comedi_do_insn(device, &insn);
  if (ret < 0){
    comedi_perror(filename);
    exit(0);
  }

  k = 0;
  // read g0 joint status register
  data[k++] = 0x008;
  data[k++] = 0x0;
  // read g0 joint status 1 register
  data[k++] = 0x036;
  data[k++] = 0x0;
  // read g0 joint status 2 register
  data[k++] = 0x03a;
  data[k++] = 0x0;

  insn.insn = INSN_READ;
  insn.n = k;
  insn.data = data;
  insn.subdev = 0;
  insn.chanspec = DATA_2B;

  ret = comedi_do_insn(device, &insn);
  if (ret < 0){
    comedi_perror(filename);
    exit(0);
  }

  printf("0x%x: 0x%x\n", data[0], data[1]);
  printf("0x%x: 0x%x\n", data[2], data[3]);
  printf("0x%x: 0x%x\n", data[4], data[5]);

  k = 0;
  // setup g0 load a register
  data[k++] = 0x038;
  data[k++] = 0x000000ff;
  // setup g0 load b register
  data[k++] = 0x03c;
  data[k++] = 0xff00000f;

  insn.insn = INSN_WRITE;
  insn.n = k;
  insn.data = data;
  insn.subdev = 0;
  insn.chanspec = DATA_4B;

  ret = comedi_do_insn(device, &insn);
  if (ret < 0){
    comedi_perror(filename);
    exit(0);
  }

  k = 0;
  // setup g0 command register
  data[k++] = 0x00c;
  data[k++] = 0x0125;

  insn.insn = INSN_WRITE;
  insn.n = k;
  insn.data = data;
  insn.subdev = 0;
  insn.chanspec = DATA_2B;

  ret = comedi_do_insn(device, &insn);
  if (ret < 0){
    comedi_perror(filename);
    exit(0);
  }

  k = 0;
  // read g0 joint status register
  data[k++] = 0x008;
  data[k++] = 0x0;
  // read g0 joint status 1 register
  data[k++] = 0x036;
  data[k++] = 0x0;
  // read g0 joint status 2 register
  data[k++] = 0x03a;
  data[k++] = 0x0;

  insn.insn = INSN_READ;
  insn.n = k;
  insn.data = data;
  insn.subdev = 0;
  insn.chanspec = DATA_2B;

  ret = comedi_do_insn(device, &insn);
  if (ret < 0){
    comedi_perror(filename);
    exit(0);
  }

  printf("0x%x: 0x%x\n", data[0], data[1]);
  printf("0x%x: 0x%x\n", data[2], data[3]);
  printf("0x%x: 0x%x\n", data[4], data[5]);

  k = 0;
  // setup g0 command register
  data[k++] = 0x00c;
  data[k++] = 0x0120;

  insn.insn = INSN_WRITE;
  insn.n = k;
  insn.data = data;
  insn.subdev = 0;
  insn.chanspec = DATA_2B;

  ret = comedi_do_insn(device, &insn);
  if (ret < 0){
    comedi_perror(filename);
    exit(0);
  }

  for (i=0; i<4; i++) {
    k = 0;
    // read g0 SW save register
    data[k++] = 0x018;
    data[k++] = 0x0;
    insn.insn = INSN_READ;
    insn.n = k;
    insn.data = data;
    insn.subdev = 0;
    insn.chanspec = DATA_4B;

    ret = comedi_do_insn(device, &insn);
    if (ret < 0){
      comedi_perror(filename);
      exit(0);
    }

    printf("0x%x: 0x%x\n", data[0], data[1]);

    getchar();
  }

  comedi_close(device);

  return 0;
}

